<?php
if (!class_exists('VC_Extensions_TestimonialList')) {
    class VC_Extensions_TestimonialList{
        function VC_Extensions_TestimonialList() {
            vc_map(array(
            "name" => __("Testimonial List", 'vc_testimoniallist_cq'),
            "base" => "cq_vc_testimoniallist",
            "class" => "wpb_cq_vc_extension_testimoniallist",
            "icon" => "cq_allinone_testimoniallist",
            "category" => __('Sike Extensions', 'js_composer'),
            // "show_settings_on_create" => false,
            'description' => __('With scroll to view slideshow', 'js_composer'),
            "params" => array(
              array(
                "type" => "attach_images",
                "heading" => __("Avatar images:", "vc_testimoniallist_cq"),
                "param_name" => "images",
                "value" => "",
                "group" => "Avatar",
                "description" => __("Select images from media library.", "vc_testimoniallist_cq")
              ),
              array(
                "type" => "dropdown",
                "holder" => "",
                "heading" => __("Resize the avatar image?", "vc_testimoniallist_cq"),
                "param_name" => "isresize",
                "value" => array("no", "yes (specify the image width below)"=>"yes"),
                "std" => "yes",
                "group" => "Avatar",
                "description" => __("", "vc_testimoniallist_cq")
              ),
              array(
                "type" => "textfield",
                "heading" => __("Resize image to this width", "vc_testimoniallist_cq"),
                "param_name" => "imagewidth",
                "value" => "160",
                "dependency" => Array('element' => "isresize", 'value' => array('yes')),
                "group" => "Avatar",
                "description" => __("Default is 160, the avatar is in 80x80, so the avatar image will be displayed in retina. Please note the image resize function may not work with some server setup, then you have to disable it.", "vc_testimoniallist_cq")
              ),
              array(
                "type" => "exploded_textarea",
                "heading" => __("User name under the avatar", "vc_testimoniallist_cq"),
                "param_name" => "username",
                "value" => "",
                "group" => "Avatar",
                "description" => __("Optional user name under each avatar, divide with linebreak (Enter)", "vc_testimoniallist_cq")
              ),
              array(
                "type" => "exploded_textarea",
                "heading" => __("User role label (optional)", "vc_testimoniallist_cq"),
                "param_name" => "userrole",
                "value" => "",
                "group" => "Avatar",
                "description" => __("Optional user role under each avatar, divide with linebreak (Enter)", "vc_testimoniallist_cq")
              ),
              array(
                "type" => "colorpicker",
                "holder" => "div",
                "class" => "",
                "heading" => __("Font color the optional user name and role", 'vc_testimoniallist_cq'),
                "param_name" => "namecolor",
                "value" => "",
                "group" => "Avatar",
                "description" => __("Default is dark gray.", 'vc_testimoniallist_cq')
              ),
              array(
                'type' => 'dropdown',
                'heading' => __( 'Icon library (select a global default icon for the avatar without image)', 'js_composer' ),
                'value' => array(
                  __( 'Font Awesome', 'js_composer' ) => 'fontawesome',
                  __( 'Open Iconic', 'js_composer' ) => 'openiconic',
                  __( 'Typicons', 'js_composer' ) => 'typicons',
                  __( 'Entypo', 'js_composer' ) => 'entypo',
                  __( 'Linecons', 'js_composer' ) => 'linecons',
                ),
                'admin_label' => true,
                'param_name' => 'avataricon',
                "group" => "Avatar",
                'description' => __( 'Select icon library.', 'js_composer' ),
              ),
              array(
                'type' => 'iconpicker',
                'heading' => __( 'Icon', 'js_composer' ),
                'param_name' => 'icon_fontawesome',
                'value' => 'fa fa-bullhorn', // default value to backend editor admin_label
                'settings' => array(
                  'emptyIcon' => true, // default true, display an "EMPTY" icon?
                  'iconsPerPage' => 4000, // default 100, how many icons per/page to display, we use (big number) to display all icons in single page
                ),
                'dependency' => array(
                  'element' => 'avataricon',
                  'value' => 'fontawesome',
                ),
                "group" => "Avatar",
                'description' => __( 'Select icon from library.', 'js_composer' ),
              ),
              array(
                'type' => 'iconpicker',
                'heading' => __( 'Icon', 'js_composer' ),
                'param_name' => 'icon_openiconic',
                'value' => 'vc-oi vc-oi-dial', // default value to backend editor admin_label
                'settings' => array(
                  'emptyIcon' => false, // default true, display an "EMPTY" icon?
                  'type' => 'openiconic',
                  'iconsPerPage' => 4000, // default 100, how many icons per/page to display
                ),
                'dependency' => array(
                  'element' => 'avataricon',
                  'value' => 'openiconic',
                ),
                "group" => "Avatar",
                'description' => __( 'Select icon from library.', 'js_composer' ),
              ),
              array(
                'type' => 'iconpicker',
                'heading' => __( 'Icon', 'js_composer' ),
                'param_name' => 'icon_typicons',
                'value' => 'typcn typcn-adjust-brightness', // default value to backend editor admin_label
                'settings' => array(
                  'emptyIcon' => false, // default true, display an "EMPTY" icon?
                  'type' => 'typicons',
                  'iconsPerPage' => 4000, // default 100, how many icons per/page to display
                ),
                'dependency' => array(
                  'element' => 'avataricon',
                  'value' => 'typicons',
                ),
                "group" => "Avatar",
                'description' => __( 'Select icon from library.', 'js_composer' ),
              ),
              array(
                'type' => 'iconpicker',
                'heading' => __( 'Icon', 'js_composer' ),
                'param_name' => 'icon_entypo',
                'value' => 'entypo-icon entypo-icon-note', // default value to backend editor admin_label
                'settings' => array(
                  'emptyIcon' => false, // default true, display an "EMPTY" icon?
                  'type' => 'entypo',
                  'iconsPerPage' => 4000, // default 100, how many icons per/page to display
                ),
                "group" => "Avatar",
                'dependency' => array(
                  'element' => 'avataricon',
                  'value' => 'entypo',
                ),
              ),
              array(
                'type' => 'iconpicker',
                'heading' => __( 'Icon', 'js_composer' ),
                'param_name' => 'icon_linecons',
                'value' => 'vc_li vc_li-heart', // default value to backend editor admin_label
                'settings' => array(
                  'emptyIcon' => false, // default true, display an "EMPTY" icon?
                  'type' => 'linecons',
                  'iconsPerPage' => 4000, // default 100, how many icons per/page to display
                ),
                'dependency' => array(
                  'element' => 'avataricon',
                  'value' => 'linecons',
                ),
                "group" => "Avatar",
                'description' => __( 'Select icon from library.', 'js_composer' ),
              ),
              array(
                "type" => "colorpicker",
                "holder" => "div",
                "class" => "",
                "heading" => __("Background color of the avatar", 'vc_testimoniallist_cq'),
                "param_name" => "avatarbg",
                "value" => "",
                "group" => "Avatar",
                "description" => __("Default is light gray.", 'vc_testimoniallist_cq')
              ),
              array(
                "type" => "colorpicker",
                "holder" => "div",
                "class" => "",
                "heading" => __("Color of the avatar icon", 'vc_testimoniallist_cq'),
                "param_name" => "avatarcolor",
                "value" => "",
                "group" => "Avatar",
                "description" => __("Default is dark gray.", 'vc_testimoniallist_cq')
              ),
              array(
                "type" => "dropdown",
                "holder" => "",
                "class" => "vc_testimoniallist_cq",
                "heading" => __("Display how many avatar by default (in large screen)", "vc_testimoniallist_cq"),
                "param_name" => "avatarnum1",
                "value" => array(3, 5, 7, 9),
                "std" => "3",
                "group" => "Avatar",
                "description" => __("This is the default number, and display in screen large than or equal 1280. Note, this number must be <strong>less than</strong> the whole avatar number.", "vc_testimoniallist_cq")
              ),
              array(
                "type" => "dropdown",
                "holder" => "",
                "class" => "vc_testimoniallist_cq",
                "heading" => __("Display how many avatar (in tablet screen, like iPad)", "vc_testimoniallist_cq"),
                "param_name" => "avatarnum2",
                "value" => array(3, 5, 7, 9),
                "std" => "3",
                "group" => "Avatar",
                "description" => __("Display how many avatars in screen smaller than 800. Default is 3. Note this number must less than the whole avatar number.", "vc_testimoniallist_cq")
              ),
              array(
                "type" => "dropdown",
                "holder" => "",
                "class" => "vc_testimoniallist_cq",
                "heading" => __("Display how many avatar (in mobile screen, like iPhone)", "vc_testimoniallist_cq"),
                "param_name" => "avatarnum3",
                "value" => array(3, 5, 7, 9),
                "std" => "3",
                "group" => "Avatar",
                "description" => __("Display how many avatars in screen smaller than 640. Default is 3.", "vc_testimoniallist_cq")
              ),
              array(
                "type" => "exploded_textarea",
                "heading" => __("Optional title for each testimonial", "vc_testimoniallist_cq"),
                "param_name" => "titles",
                "value" => "",
                "group" => "Text",
                "description" => __("Divide with linebreak (Enter)", "vc_testimoniallist_cq")
              ),
              array(
                "type" => "textarea_html",
                "holder" => "div",
                "heading" => __("Testimonial content, divide each one with [testimonialitem][/testimonialitem], please try to edit in Text mode:", "vc_testimoniallist_cq"),
                "param_name" => "content",
                "group" => "Text",
                "value" => __("", "vc_testimoniallist_cq"),
                "std" => '[testimonialitem]Testimonial 1[/testimonialitem]
                	[testimonialitem]Testimonial 2[/testimonialitem]
                	[testimonialitem]Testimonial 3[/testimonialitem]
                	[testimonialitem]Yet another testimonial[/testimonialitem]',
                "description" => __("", "vc_testimoniallist_cq")
              ),

              // array(
              //   "type" => "colorpicker",
              //   "holder" => "div",
              //   "class" => "",
              //   "heading" => __("Font color the content", 'vc_testimoniallist_cq'),
              //   "param_name" => "contentcolor",
              //   "value" => "",
              //   "group" => "Text",
              //   "description" => __("Default is white.", 'vc_testimoniallist_cq')
              // ),
              array(
                "type" => "dropdown",
                "holder" => "",
                "class" => "vc_testimoniallist_cq",
                "heading" => __("Text align", "vc_testimoniallist_cq"),
                "param_name" => "textalign",
                "value" => array("left", "center", "right"),
                'std' => 'left',
                "group" => "Text",
                "description" => __("", "vc_testimoniallist_cq")
              ),
              // array(
              //   "type" => "textfield",
              //   "heading" => __("min height of the content", "vc_testimoniallist_cq"),
              //   "param_name" => "minheight",
              //   "value" => "",
              //   "group" => "Text",
              //   "description" => __("The height for the content is the largest one by default. Thought you can specify a value here to keep all content in a fixed same height.", "vc_testimoniallist_cq")
              // ),
              array(
                "type" => "textfield",
                "heading" => __("CSS padding of the content", "vc_testimoniallist_cq"),
                "param_name" => "contentpadding",
                "value" => "",
                "group" => "Text",
                "description" => __("The padding of the content is 32px by default. You can specify other value here.", "vc_testimoniallist_cq")
              ),
              array(
                "type" => "dropdown",
                "holder" => "",
                "class" => "vc_testimoniallist_cq",
                "heading" => __("The text block background", "vc_testimoniallist_cq"),
                "param_name" => "textblockbg",
                "value" => array("Grape Fruit" => "grapefruit", "Bitter Sweet" => "bittersweet", "Sunflower" => "sunflower", "Grass" => "grass", "Mint" => "mint", "Aqua" => "aqua", "Blue Jeans" => "bluejeans", "Lavender" => "lavender", "Pink Rose" => "pinkrose", "Light Gray" => "lightgray", "Medium Gray" => "mediumgray", "Dark Gray" => "darkgray"),
                'std' => 'lavender',
                "description" => __("", "vc_testimoniallist_cq")
              ),
              array(
                "type" => "dropdown",
                "holder" => "",
                "class" => "vc_testimoniallist_cq",
                "heading" => __("Auto display the testimonial in slideshow? Select the auto delay time in second below.", "vc_testimoniallist_cq"),
                "param_name" => "delaytime",
                "value" => array("no slideshow" => "no", "2", "3", "4", "5", "6", "7", "8", "9", "10"),
                'std' => 'no',
                "description" => __("The auto slideshow is disabled by default. You can select a auto delay time if you want to enable it.", "vc_testimoniallist_cq")
              ),
              array(
                "type" => "dropdown",
                "holder" => "",
                "class" => "vc_testimoniallist_cq",
                "heading" => __("Element shape", "vc_testimoniallist_cq"),
                "param_name" => "elementshape",
                "value" => array("rounded (small)" => "roundsmall", "rounded (large)" => "roundlarge", "square" => "square"),
                "std" => "square",
                "description" => __("", "vc_testimoniallist_cq")
              ),
              array(
                "type" => "textfield",
                "heading" => __("Extra class name", "vc_testimoniallist_cq"),
                "param_name" => "extraclass",
                "value" => "",
                "description" => __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "vc_testimoniallist_cq")
              )

           )
        ));

        function cq_vc_testimoniallist_func($atts, $content=null, $tag) {
          $avataricon = $icon_fontawesome = $icon_openiconic = $icon_typicons = $icon_entypo = $icon_linecons = '';
          if(version_compare(WPB_VC_VERSION,  "4.6") >= 0){
              $atts = vc_map_get_attributes($tag, $atts);
              extract($atts);
          }else{
            extract(shortcode_atts(array(
              "icon_fontawesome" => '',
              "icon_openiconic" => '',
              "icon_typicons" => '',
              "icon_entypo" => '',
              "icon_linecons" => '',
              "avataricon" => '',
              "images" => "",
              "imagewidth" => "",
              "textblockbg" => "lavender",
              "textalign" => "",
              "isresize" => "no",
              "username" => "",
              "userrole" => "",
              "namecolor" => "",
              "avatarbg" => "",
              "avatarcolor" => "",
              "elementshape" => "square",
              "avatarnum1" => "",
              "avatarnum2" => "",
              "avatarnum3" => "",
              "delaytime" => "",
              "titles" => "",
              "minheight" => "",
              "contentpadding" => "",
              "extraclass" => ""
            ), $atts));

          }

          if(version_compare(WPB_VC_VERSION,  "4.4")>= 0){
            vc_icon_element_fonts_enqueue($avataricon);
          }else{
            // wp_register_style( 'font-awesome', plugins_url('../faanimation/css/font-awesome.min.css', __FILE__) );
            // wp_enqueue_style( 'font-awesome' );
          }



          $content = wpb_js_remove_wpautop($content); // fix unclosed/unwanted paragraph tags in $content
          $content = str_replace('[/testimonialitem]', '', trim($content));
          $contentarr = explode('[testimonialitem]', trim($content));
          array_shift($contentarr);
          $imagesarr = explode(',', $images);
          $username = explode(',', $username);
          $userrole = explode(',', $userrole);
          $titles = explode(',', $titles);

          $color_style_arr = array("grapefruit" => array("#ED5565", "#DA4453"), "bittersweet" => array("#FC6E51", "#E9573F"), "sunflower" => array("#FFCE54", "#F6BB42"), "grass" => array("#A0D468", "#8CC152"), "mint" => array("#48CFAD", "#37BC9B"), "aqua" => array("#4FC1E9", "#3BAFDA"), "bluejeans" => array("#5D9CEC", "#4A89DC"), "lavender" => array("#AC92EC", "#967ADC"), "pinkrose" => array("#EC87C0", "#D770AD"), "lightgray" => array("#F5F7FA", "#E6E9ED"), "mediumgray" => array("#CCD1D9", "#AAB2BD"), "darkgray" => array("#656D78", "#434A54"));



          wp_register_style( 'vc-extensions-testimoniallist-style', plugins_url('css/style.min.css', __FILE__) );
          wp_enqueue_style( 'vc-extensions-testimoniallist-style' );
          wp_register_style('slick', plugins_url('../testimonialcarousel/slick/slick.css', __FILE__));
          wp_enqueue_style('slick');

          wp_register_script('slick', plugins_url('../testimonialcarousel/slick/slick.min.js', __FILE__), array("jquery"));
          wp_enqueue_script('slick');

          wp_register_script('vc-extensions-testimoniallist-script', plugins_url('js/init.min.js', __FILE__), array("jquery", "slick"));
          wp_enqueue_script('vc-extensions-testimoniallist-script');


          $output = '';
          $text_output = '';
          $image_output = '';

          $output .= '<div class="cq-testimoniallist '.$textblockbg.' '.$elementshape.' '.$extraclass.'" data-avatarbg="'.$avatarbg.'" data-avatarcolor="'.$avatarcolor.'" data-avatarnum1="'.$avatarnum1.'" data-avatarnum2="'.$avatarnum2.'" data-avatarnum3="'.$avatarnum3.'" data-delaytime="'.$delaytime.'" data-textalign="'.$textalign.'" data-namecolor="'.$namecolor.'"  data-contentpadding="'.$contentpadding.'">';

          $text_output .= '<div class="cq-testimoniallist-contentcontainer">';
          $text_output .= '<div class="cq-testimoniallist-contentsub">';


          $i = -1;
          $image_output .= '<div class="cq-testimoniallist-avatarcontainer">';
          foreach ($contentarr as $key => $thecontent) {
              $i++;
              $thecontent = trim($thecontent);
              $thecontent = preg_replace("/(^)?(<br\s*\/?>\s*)+$/", "", $thecontent);
              $thecontent = preg_replace('/^(<br \/>)*/', "", $thecontent);
              $thecontent = preg_replace('/^(<\/p>)*/', "", $thecontent);
              // if(!isset($username[$i])) $username[$i] = '';
              // if(!isset($userrole[$i])) $userrole[$i] = '';
              // if(!isset($titles[$i])) $titles[$i] = '';

              if($thecontent!=""){
                  $text_output .= '<div class="cq-testimoniallist-contentitem">';
                  $text_output .= '<div class="cq-testimoniallist-content">';
                  if(isset($titles[$i])){
	                  $text_output .= '<h4 class="cq-testimoniallist-title">';
	                  $text_output .= $titles[$i];
	                  $text_output .= '</h4>';
                  }
                  $text_output .= $thecontent;
                  $text_output .= '</div>';
                  $text_output .= '</div>';

                  // $image_output .= '<div class="cq-testimoniallist-avataritem" data-index="'.($i).'">';
                  $image_output .= '<div class="cq-testimoniallist-avataritem">';
                  if(isset($imagesarr[$i])&&$imagesarr[$i]!=""){
                    $attachment = get_post($imagesarr[$i]);
                    $imageLocation = wp_get_attachment_image_src($imagesarr[$i], 'full');

                    $testimonial_image_temp = $testimonialimage = "";
                    $fullimage = $imagesarr[$i];
                    $testimonialimage = $fullimage;
                    if($imagewidth!=""){
                        if(function_exists('wpb_resize')){
                            $testimonial_image_temp = wpb_resize($imagesarr[$i], null, $imagewidth, $imagewidth, true);
                            $testimonialimage = $testimonial_image_temp['url'];
                            if($testimonialimage=="") $testimonialimage = $fullimage;
                        }
                    }


                    if($imageLocation[0]!="") $image_output .= '<img src="'.$testimonialimage.'" class="cq-testimoniallist-image" alt="'.get_post_meta($attachment->ID, '_wp_attachment_image_alt', true ).'">';
                  }else{
                      $image_output .= '<span class="cq-testimoniallist-avatar">';
                      if(version_compare(WPB_VC_VERSION,  "4.4")>=0 && isset(${'icon_' . $avataricon})){
                          $image_output .= '<i class="cq-testimoniallist-icon '.esc_attr(${'icon_' . $avataricon}).'"></i>';
                      }else{
                          $image_output .= '<i class="fa cq-testimoniallist-icon '.$avataricon.'"></i>';
                      }
                      $image_output .= '</span>';
                  }
                  if(isset($username[$i])){
                      $image_output .= '<span class="cq-testimoniallist-name">';
                      $image_output .= $username[$i];
                      $image_output .= '</span>';
                  }
                  if(isset($userrole[$i])){
                      $image_output .= '<span class="cq-testimoniallist-label">';
                      $image_output .= $userrole[$i];
                      $image_output .= '</span>';
                  }

                  $image_output .= '</div>';



              }


          }

          $image_output .= '</div>';

          $text_output .= '</div>';
          $text_output .= '</div>';

          $output .= $text_output.$image_output;

          $output .= '</div>';

          return $output;

        }

        add_shortcode('cq_vc_testimoniallist', 'cq_vc_testimoniallist_func');

      }
  }

}

?>
